<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Testcontroller;

use App\Http\Controllers\Admin\Authcontroller;
use App\Http\Controllers\Admin\Getcontroller;
use App\Http\Controllers\Admin\Storecontroller;
use App\Http\Controllers\Admin\Putcontroller;
use App\Http\Controllers\Admin\Deletecontroller;

use App\Http\Controllers\Landingcontroller;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [Landingcontroller::class, 'index'])->name('landingpage');
Route::post('/admin/pesan/store', [Storecontroller::class, 'pesan'])->name('pesanstore');
Route::get('/blog/read/{id}', [Landingcontroller::class, 'blogview'])->name('viewblog');
Route::get('/blog', [Landingcontroller::class, 'viewallblog'])->name('viewallblog');

Route::get('/view/portfolio', [Landingcontroller::class, 'viewportfolio'])->name('viewportfolio');

Route::get('/admin/', [Authcontroller::class, 'login'])->name('login');
Route::post('/admin/login/action', [Authcontroller::class, 'proses'])->name('login.action');
Route::get('/admin/logout', [Authcontroller::class, 'logout'])->name('logout');

Route::get('/admin/home', [Getcontroller::class, 'home'])->name('home');
Route::get('/admin/achievement', [Getcontroller::class, 'achievement'])->name('achievement');
Route::get('/admin/portfolio', [Getcontroller::class, 'portfolio'])->name('portfolio');
Route::get('/admin/testimoni', [Getcontroller::class, 'testimoni'])->name('testimoni');
Route::get('/admin/pesan', [Getcontroller::class, 'pesan'])->name('pesan');
Route::get('/admin/about', [Getcontroller::class, 'about'])->name('about');
Route::get('/admin/blog', [Getcontroller::class, 'blog'])->name('blog');

Route::get('/admin/experience/view', [Getcontroller::class, 'experienceview'])->name('experienceview');
Route::get('/admin/education/view', [Getcontroller::class, 'educationview'])->name('educationview');
Route::get('/admin/blog/view/{id}', [Getcontroller::class, 'blogview'])->name('blogview');

Route::get('/admin/blog/tambah', [Getcontroller::class, 'blogadd'])->name('blogadd');

Route::get('/admin/achievement/json', [Getcontroller::class, 'achievementjson'])->name('achievementjson');
Route::get('/admin/portfolio/json/1', [Getcontroller::class, 'portfoliojson1'])->name('portfoliojson1');
Route::get('/admin/portfolio/json/2', [Getcontroller::class, 'portfoliojson2'])->name('portfoliojson2');
Route::get('/admin/portfolio/json/3', [Getcontroller::class, 'portfoliojson3'])->name('portfoliojson3');
Route::get('/admin/portfolio/json/4', [Getcontroller::class, 'portfoliojson4'])->name('portfoliojson4');
Route::get('/admin/portfolio/json/5', [Getcontroller::class, 'portfoliojson5'])->name('portfoliojson5');
Route::get('/admin/portfolio/json/6', [Getcontroller::class, 'portfoliojson6'])->name('portfoliojson6');
Route::get('/admin/testimoni/json', [Getcontroller::class, 'testimonijson'])->name('testimonijson');
Route::get('/admin/pesan/json', [Getcontroller::class, 'pesanjson'])->name('pesanjson');
Route::get('/admin/skill/json', [Getcontroller::class, 'skilljson'])->name('skilljson');
Route::get('/admin/experience/json', [Getcontroller::class, 'experiencejson'])->name('experiencejson');
Route::get('/admin/education/json', [Getcontroller::class, 'educationjson'])->name('educationjson');
Route::get('/admin/blog/json', [Getcontroller::class, 'blogjson'])->name('blogjson');

Route::post('/admin/achievement/add', [Storecontroller::class, 'achievement'])->name('achievementadd');
Route::post('/admin/portfolio/add', [Storecontroller::class, 'portfolio'])->name('portfolioadd');
Route::post('/admin/testimoni/add', [Storecontroller::class, 'testimoni'])->name('testimoniadd');
Route::post('/admin/skill/add', [Storecontroller::class, 'skill'])->name('skilladd');
Route::post('/admin/experience/add', [Storecontroller::class, 'experience'])->name('experienceadd');
Route::post('/admin/education/add', [Storecontroller::class, 'education'])->name('educationadd');
Route::post('/admin/blog/add', [Storecontroller::class, 'blog'])->name('blogstore');

Route::post('/admin/home/update', [Putcontroller::class, 'home'])->name('homeupdate');
Route::get('/admin/achievement/edit', [Putcontroller::class, 'achievementedit'])->name('achievementedit');
Route::post('/admin/achievement/update', [Putcontroller::class, 'achievementupdate'])->name('achievementupdate');
Route::get('/admin/portfolio/edit', [Putcontroller::class, 'portfolioedit'])->name('portfolioedit');
Route::post('/admin/portfolio/update', [Putcontroller::class, 'portfolioupdate'])->name('portfolioupdate');
Route::get('/admin/testimoni/edit', [Putcontroller::class, 'testimoniedit'])->name('testimoniedit');
Route::post('/admin/testimoni/update', [Putcontroller::class, 'testimoniupdate'])->name('testimoniupdate');
Route::post('/admin/tentang/update', [Putcontroller::class, 'tentang'])->name('tentangupdate');
Route::get('/admin/skill/edit', [Putcontroller::class, 'skilledit'])->name('skilledit');
Route::post('/admin/skill/update', [Putcontroller::class, 'skillupdate'])->name('skillupdate');
Route::get('/admin/experience/edit', [Putcontroller::class, 'experienceedit'])->name('experienceedit');
Route::post('/admin/experience/update', [Putcontroller::class, 'experienceupdate'])->name('experienceupdate');
Route::get('/admin/education/edit', [Putcontroller::class, 'educationedit'])->name('educationedit');
Route::post('/admin/education/update', [Putcontroller::class, 'educationupdate'])->name('educationupdate');
Route::get('/admin/blog/edit/{id}', [Putcontroller::class, 'blogedit'])->name('blogedit');
Route::post('/admin/blog/update', [Putcontroller::class, 'blogupdate'])->name('blogupdate');

Route::post('/admin/achievement/delete', [Deletecontroller::class, 'achievement'])->name('achievementdelete');
Route::post('/admin/portfolio/delete', [Deletecontroller::class, 'portfolio'])->name('portfoliodelete');
Route::post('/admin/testimoni/delete', [Deletecontroller::class, 'testimoni'])->name('testimonidelete');
Route::post('/admin/pesan/delete', [Deletecontroller::class, 'pesan'])->name('pesandelete');
Route::post('/admin/skill/delete', [Deletecontroller::class, 'skill'])->name('skilldelete');
Route::post('/admin/experience/delete', [Deletecontroller::class, 'experience'])->name('experiencedelete');
Route::post('/admin/education/delete', [Deletecontroller::class, 'education'])->name('educationdelete');
Route::post('/admin/blog/delete', [Deletecontroller::class, 'blog'])->name('blogdelete');

Route::get('/admin/test', [Testcontroller::class, 'index'])->name('test');

