<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::get('/v1/tentang', [ApiController::class, 'tentang_get'])->name('tentang_get');
Route::get('/v1/admin', [ApiController::class, 'admin_get'])->name('admin_get');
Route::get('/v1/achievement', [ApiController::class, 'achievement_get'])->name('achievement_get');
Route::get('/v1/portfolio', [ApiController::class, 'portfolio_get'])->name('portfolio_get');
Route::get('v1/kategori', [ApiController::class, 'kategori_portfolio_get'])->name('kategori_portfolio_get');
Route::get('/v1/testimoni', [ApiController::class, 'testimoni_get'])->name('testimoni_get');
Route::get('/v1/portfolio/{id}', [ApiController::class, 'portofolio_get_bycategory'])->name('portofolio_get_bycategory');
Route::get('/v1/pesan', [ApiController::class, 'pesan_get'])->name('pesan_get');
Route::get('/v1/skill', [ApiController::class, 'skill_get'])->name('skill_get');
Route::get('/v1/experience', [ApiController::class, 'experience_get'])->name('experience_get');
Route::get('/v1/education', [ApiController::class, 'education_get'])->name('education_get');
Route::get('/v1/blog', [ApiController::class, 'blog_get'])->name('blog_get');
Route::get('/v1/blog/{id}', [ApiController::class, 'blog_get_by_id'])->name('blog_get_by_id');
Route::get('/v1/pesan/store', [ApiController::class, 'pesan_post'])->name('pesan_post');

Route::get('/test',function(){
    return response()->json([
        'success'=>true,
        'message'=>'ok'
    ]);
});
