@extends('template.template')
@section('title','Pesan')
@section('main')

<div class="main">
	<h2><strong>Pesan</strong></h2>
	<hr>
	<br>
	<div class="data-content">
		<div class=table-control>
			<table class="table table-home table-striped table-bordered" id="pesan-table">
				<thead>
					<tr>
						<th>Nama</th>
						<th>Email</th>
						<th>Messasge</th>
						<th>Aksi</th>
					</tr>
				</thead>
				<tbody>
					
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection
@section('script')
<script type="text/javascript">

    $(function(){
	    $('#pesan-table').DataTable({
	      	processing : true,
	      	serverSide : true,
	      	responsive : true,
	      	ajax: "{{ route('pesanjson') }}",
	      	columns: [
		        {data: 'nama', name: 'nama'},
		        {data: 'email', name: 'email'},
		        {data: 'message', name: 'message'},
		        {data: 'aksi', name: 'aksi'}
	        ]
	    });
  	});

  	$(document).on('click', '.hapus', function(){
      	let id = $(this).attr('id');
      	$.ajax({
        	url : "{{ route('pesandelete') }}",
        	type : 'post',
        	data : {
          		id : id,
          		'_token' : "{{ csrf_token() }}"
        	},
        	success: function(params){
	          	alert(params.text);
	          	window.location = "{{route('pesan')}}"
	        },
        	error: function(xhr){
          		alert(xhr)
        	}
      	});
    });
</script>
@endsection