@extends('template.template')
@section('title','Portfolio')
@section('main')
<div class="main">
	<h2><strong>About</strong></h2>
	<hr>
	<br>
	<select id="portchange" onchange="aboutchange()" class="form-control">
		<option value="1">About</option>
		<option value="2">Skill</option>
		<option value="3">Experience</option>
		<option value="4">Education</option>
	</select>
	@foreach($tentang as $ttg)
	<div class="data-content" id="check1">
		<button class="btn black mt-2" data-bs-toggle="modal" data-bs-target="#updatedataAbout">Edit Data</button>
		<br /><br />
		<div class="form-group text-center float-start col-lg-2 col-md-3 col-12 pe-lg-3">
			<div class="border border-dark rounded p-2">
				<h4><strong>Foto About</strong></h4>
				<hr>
				<div class="black pt-1 rounded mt-2">
					<img src="{{asset('mystyle/image/'.$ttg->foto_about)}}" class="w-50">
				</div>
			</div>
		</div>
		<div class="float-start col-lg-9 col-md-8 col-12 ps-lg-3 ps-md-3">
			<div class=table-control>
				<table class="table table-home table-striped table-bordered">
					<tr>
						<th>Link Blog</th>
						<td>: {{$ttg->link_blog}}</td>
					</tr>
					<tr>
						<th>Link Instagram</th>
						<td>: {{$ttg->link_instagram}}</td>
					</tr>
					<tr>
						<th>Link Twitter</th>
						<td>: {{$ttg->link_twitter}}</td>
					</tr>
					<tr>
						<th>Link Facebook</th>
						<td>: {{$ttg->link_facebook}}</td>
					</tr>
					<tr>
						<th>Link Linkedin</th>
						<td>: {{$ttg->link_linkedin}}</td>
					</tr>
					<tr>
						<th>Tentang</th>
						<td>: {{$ttg->tentang}}</td>
					</tr>
					<tr>
						<th>Link CV</th>
						<td>: {{$ttg->link_cv}}</td>
					</tr>
				</table>
			</div>
		</div>
		<div class="clearfix"></div>
	</div>
	@endforeach
	<div class="clearfix"></div>
	<div class="data-content d-none" id="check2">
		<h3>Skill</h3>
		<hr>
		<button class="btn black mt-2" data-bs-toggle="modal" data-bs-target="#adddataSkill">Tambah Data</button>
		<br /><br />
		<div class=table-control>
			<table class="w-100 table table-home table-striped table-bordered" id="skill-table">
				<thead>
					<tr>
						<th>Nama Skill</th>
						<th>Persentase</th>
						<th>Aksi</th>
					</tr>
				</thead>
				<tbody>
					
				</tbody>
			</table>
		</div>
	</div>
	<div class="data-content d-none" id="check3">
		<h3>Eksperience</h3>
		<hr>
		<button class="btn black mt-2" data-bs-toggle="modal" data-bs-target="#adddataExperience">Tambah Data</button>
		<br /><br />
		<div class=table-control>
			<table class="w-100 table table-home table-striped table-bordered" id="experience-table">
				<thead>
					<tr>
						<th>Tanggal</th>
						<th>Nama</th>
						<th>Penyelenggara</th>
						<th>Aksi</th>
					</tr>
				</thead>
				<tbody>
					
				</tbody>
			</table>
		</div>
	</div>
	<div class="data-content d-none" id="check4">
		<h3>Education</h3>
		<hr>
		<button class="btn black mt-2" data-bs-toggle="modal" data-bs-target="#adddataEducation">Tambah Data</button>
		<br /><br />
		<div class=table-control>
			<table class="w-100 table table-home table-striped table-bordered" id="education-table">
				<thead>
					<tr>
						<th>Tahun</th>
						<th>Nama Sekolah</th>
						<th>Jurusan</th>
						<th>Aksi</th>
					</tr>
				</thead>
				<tbody>
					
				</tbody>
			</table>
		</div>
	</div>

</div>
<div class="modal fade" id="updatedataAbout" tabindex="-1" aria-labelledby="updatedataAboutLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="updatedataAboutLabel">Update Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			@foreach($tentang as $ttg)
	   			<form action="{{ route('tentangupdate') }}" method="post" enctype="multipart/form-data">
	   			@csrf
	   				<input type="hidden" name="id" value="{{$ttg->id}}">
	   				<div class="form-group">
	   					<label><strong>Foto About</strong></label>
	   					<input type="file" name="foto_about" class="form-control">
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Link Blog</strong></label>
	   					<input type="text" name="link_blog" class="form-control" value="{{$ttg->link_blog}}" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Link Instagram</strong></label>
	   					<input type="text" name="link_instagram" class="form-control" value="{{$ttg->link_instagram}}" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Link Twitter</strong></label>
	   					<input type="text" name="link_twitter" class="form-control" value="{{$ttg->link_twitter}}" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Link Facebook</strong></label>
	   					<input type="text" name="link_facebook" class="form-control" value="{{$ttg->link_facebook}}" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Link Linkedin</strong></label>
	   					<input type="text" name="link_linkedin" class="form-control" value="{{$ttg->link_linkedin}}" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Tentang</strong></label>
	   					<textarea rows="5" name="tentang" class="form-control" required>{{$ttg->tentang}}</textarea>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Link CV</strong></label>
	   					<input type="text" name="link_cv" class="form-control" value="{{$ttg->link_cv}}" required>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
	   			@endforeach
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="adddataSkill" tabindex="-1" aria-labelledby="adddataSkillLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="adddataSkillLabel">Tambah Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<form action="{{ route('skilladd') }}" method="post">
	   			@csrf
	   				<div class="form-group">
	   					<label><strong>Nama Skill</strong></label>
	   					<input type="text" name="nama_skill" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Persentase</strong></label>
	   					<input type="number" max="100" name="persentase" class="form-control" required>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="updatedataSkill" tabindex="-1" aria-labelledby="updatedataSkillLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="updatedataSkillLabel">Update Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<form action="{{ route('skillupdate') }}" id="formupdateskill" method="post">
	   			@csrf
	   				<input type="hidden" name="id_skill">
	   				<div class="form-group">
	   					<label><strong>Nama Skill</strong></label>
	   					<input type="text" name="nama_skill_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Persentase</strong></label>
	   					<input type="number" max="100" name="persentase_update" class="form-control" required>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="adddataExperience" tabindex="-1" aria-labelledby="adddataExperienceLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="adddataExperienceLabel">Tambah Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<form action="{{ route('experienceadd') }}" method="post">
	   			@csrf
	   				<div class="form-group">
	   					<label><strong>Tanggal</strong></label>
	   					<input type="text" name="tanggal" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Nama</strong></label>
	   					<input type="text" name="nama" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Penyelenggara</strong></label>
	   					<input type="text" name="penyelenggara" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Keterangan</strong></label>
	   					<textarea class="ckeditor" id="ckeditor" name="keterangan" required></textarea>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="viewdataExperience" tabindex="-1" aria-labelledby="viewdataExperienceLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="viewdataExperienceLabel">View Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<div id="viewdataex">
	   				<div class="form-group">
	   					<strong>Tanggal : </strong>
		   				<div id="tgl"></div> 
	   				</div>
		   			<br />
		   			<div class="form-group">
	   					<strong>Nama : </strong>
		   				<div id="nm"></div> 
	   				</div>
		   			<br />
		   			<div class="form-group">
	   					<strong>Penyelenggara : </strong>
		   				<div id="plgr"></div> 
	   				</div>
		   			<br />
		   			<div class="form-group">
	   					<strong>Keterangan : </strong>
		   				<div id="ktrngn"></div> 
	   				</div>
		   			<br />
	   			</div>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="updatedataexperience" tabindex="-1" aria-labelledby="updatedataexperienceLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="updatedataexperienceLabel">Update Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<form action="{{ route('experienceupdate') }}" id="formupdateexperience" method="post">
	   			@csrf
	   				<input type="hidden" name="id_experience">
	   				<div class="form-group">
	   					<label><strong>Tanggal</strong></label>
	   					<input type="text" name="tanggal_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Nama</strong></label>
	   					<input type="text" name="nama_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Penyelenggara</strong></label>
	   					<input type="text" name="penyelenggara_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Keterangan</strong></label>
	   					<textarea class="ckeditor" id="keterangan_update" name="keterangan_update" required></textarea>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="adddataEducation" tabindex="-1" aria-labelledby="adddataEducationLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="adddataEducationLabel">Tambah Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<form action="{{ route('educationadd') }}" method="post">
	   			@csrf
	   				<div class="form-group">
	   					<label><strong>Tahun</strong></label>
	   					<input type="text" name="tahun" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Nama Sekolah</strong></label>
	   					<input type="text" name="nama_sekolah" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Jurusan</strong></label>
	   					<input type="text" name="jurusan" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Keterangan</strong></label>
	   					<textarea class="ckeditor" id="ckeditor" name="keterangan_edu" required></textarea>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="viewdataEduction" tabindex="-1" aria-labelledby="viewdataEductionLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="viewdataEductionLabel">View Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<div id="viewdataex">
	   				<div class="form-group">
	   					<strong>Tahun : </strong>
		   				<div id="thn"></div> 
	   				</div>
		   			<br />
		   			<div class="form-group">
	   					<strong>Nama Sekolah : </strong>
		   				<div id="nms"></div> 
	   				</div>
		   			<br />
		   			<div class="form-group">
	   					<strong>Jurusan : </strong>
		   				<div id="jrsn"></div> 
	   				</div>
		   			<br />
		   			<div class="form-group">
	   					<strong>Keterangan : </strong>
		   				<div id="ktrngnedu"></div> 
	   				</div>
		   			<br />
	   			</div>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
  			</div>
  		</div>	
	</div>
</div>

<div class="modal fade" id="updatedataeducation" tabindex="-1" aria-labelledby="updatedataeducationLabel" aria-hidden="true">
    <div class="modal-dialog">
		<div class="modal-content">
   			<div class="modal-header">
   				<h1 class="modal-title fs-5" id="updatedataeducationLabel">Update Data</h1>
   				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" />
   			</div>
	   		<div class="modal-body">
	   			<form action="{{ route('educationupdate') }}" id="formupdateeducation" method="post">
	   			@csrf
	   				<input type="hidden" name="id_education">
	   				<div class="form-group">
	   					<label><strong>Tahun</strong></label>
	   					<input type="text" name="tahun_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Nama Sekolah</strong></label>
	   					<input type="text" name="nama_sekolah_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Jurusan</strong></label>
	   					<input type="text" name="jurusan_update" class="form-control" required>
	   				</div>
	   				<div class="form-group">
	   					<label><strong>Keterangan</strong></label>
	   					<textarea class="ckeditor" id="keterangan_edu_update" name="keterangan_edu_update" required></textarea>
	   				</div>
      			<div class="text-center mt-3"></div>
  				<button type="submit" class="btn black">Simpan</button>
  				<div class="btn oren" data-bs-dismiss="modal" aria-label="Close" >Close</div>
	   			</form>
  			</div>
  		</div>	
	</div>
</div>
@endsection
@section('script')

<script type="text/javascript">
	let check1 = document.getElementById('check1');
	let check2 = document.getElementById('check2');
	let check3 = document.getElementById('check3');
	let check4 = document.getElementById('check4');

	function aboutchange(){
		let portchange = document.getElementById('portchange').value;
		if(portchange == 1){
			check1.classList.remove('d-none')
			check2.classList.add('d-none')
			check3.classList.add('d-none')
			check4.classList.add('d-none')
		} else if(portchange == 2){
			check1.classList.add('d-none')
			check2.classList.remove('d-none')
			check3.classList.add('d-none')
			check4.classList.add('d-none')
		} else if(portchange == 3){
			check1.classList.add('d-none')
			check2.classList.add('d-none')
			check3.classList.remove('d-none')
			check4.classList.add('d-none')
		} else if(portchange == 4){
			check1.classList.add('d-none')
			check2.classList.add('d-none')
			check3.classList.add('d-none')
			check4.classList.remove('d-none')
		}
	}
</script>
<!-- Read Data JSON -->
	<script type="text/javascript">
		$(function(){
		    $('#skill-table').DataTable({
		      	processing : true,
		      	serverSide : true,
		      	responsive : true,
		      	ajax: "{{ route('skilljson') }}",
		      	columns: [
			        {data: 'nama_skill', name: 'nama_skill'},
			        {data: 'persentase', name: 'persentase'},
			        {data: 'aksi', name: 'aksi'}
		        ]
		    });
	  	});
	  	$(function(){
		    $('#experience-table').DataTable({
		      	processing : true,
		      	serverSide : true,
		      	responsive : true,
		      	ajax: "{{ route('experiencejson') }}",
		      	columns: [
			        {data: 'tanggal', name: 'tanggal'},
			        {data: 'nama', name: 'nama'},
			        {data: 'penyelenggara', name: 'penyelenggara'},
			        {data: 'aksi', name: 'aksi'}
		        ]
		    });
	  	});
	  	$(function(){
		    $('#education-table').DataTable({
		      	processing : true,
		      	serverSide : true,
		      	responsive : true,
		      	ajax: "{{ route('educationjson') }}",
		      	columns: [
			        {data: 'tahun', name: 'tahun'},
			        {data: 'nama_sekolah', name: 'nama_sekolah'},
			        {data: 'jurusan', name: 'jurusan'},
			        {data: 'aksi', name: 'aksi'}
		        ]
		    });
	  	});


	  	$(document).on('click', '.viewexperience', function(){
	    let id = $(this).attr('id');
	    var url = '{{route("experienceview")}}';
	    	$.get(url, {id:id}, function(data){
	    		console.log(data.data.tanggal)
	    		document.getElementById('tgl').innerHTML = data.data.tanggal;
	    		document.getElementById('nm').innerHTML = data.data.nama;
	    		document.getElementById('plgr').innerHTML = data.data.penyelenggara;
	    		document.getElementById('ktrngn').innerHTML = data.data.keterangan;   
	      		$('#viewdataExperience').modal('show');
	    	}, 'json');
	  	});
	  	$(document).on('click', '.viewedu', function(){
	    let id = $(this).attr('id');
	    var url = '{{route("educationview")}}';
	    	$.get(url, {id:id}, function(data){
	    		console.log(data.data.tanggal)
	    		document.getElementById('thn').innerHTML = data.data.tahun;
	    		document.getElementById('nms').innerHTML = data.data.nama_sekolah;
	    		document.getElementById('jrsn').innerHTML = data.data.jurusan;
	    		document.getElementById('ktrngnedu').innerHTML = data.data.keterangan;   
	      		$('#viewdataEduction').modal('show');
	    	}, 'json');
	  	});

	</script>
<!-- End Read -->

<!-- Update Data -->
	<script type="text/javascript">
		$(document).on('click', '.updateskill', function(){
	    let id = $(this).attr('id');
	    var url = '{{route("skilledit")}}';
	    	$.get(url, {id:id}, function(data){
	      		var updateList = $('#updatedataSkill');
				$(updateList).find('form#formupdateskill').find('input[name="id_skill"]').val(data.data.id);
				$(updateList).find('form#formupdateskill').find('input[name="nama_skill_update"]').val(data.data.nama_skill);
				$(updateList).find('form#formupdateskill').find('input[name="persentase_update"]').val(data.data.persentase);
	      		$('#updatedataSkill').modal('show');
	    	//alert(id);
	    	}, 'json');
	  	});

		$(document).on('click', '.updateexperience', function(){
	    let id = $(this).attr('id');
	    var url = '{{route("experienceedit")}}';
	    	$.get(url, {id:id}, function(data){
	      		var updateList = $('#updatedataexperience');
				$(updateList).find('form#formupdateexperience').find('input[name="id_experience"]').val(data.data.id);
				$(updateList).find('form#formupdateexperience').find('input[name="tanggal_update"]').val(data.data.tanggal);
				$(updateList).find('form#formupdateexperience').find('input[name="nama_update"]').val(data.data.nama);
				$(updateList).find('form#formupdateexperience').find('input[name="penyelenggara_update"]').val(data.data.penyelenggara);
				CKEDITOR.instances['keterangan_update'].setData(data.data.keterangan);
	      		$('#updatedataexperience').modal('show');
	    	//alert(id);
	    	}, 'json');
	  	});

	  	$(document).on('click', '.updateedu', function(){
	    let id = $(this).attr('id');
	    var url = '{{route("educationedit")}}';
	    	$.get(url, {id:id}, function(data){
	      		var updateList = $('#updatedataeducation');
				$(updateList).find('form#formupdateeducation').find('input[name="id_education"]').val(data.data.id);
				$(updateList).find('form#formupdateeducation').find('input[name="tahun_update"]').val(data.data.tahun);
				$(updateList).find('form#formupdateeducation').find('input[name="nama_sekolah_update"]').val(data.data.nama_sekolah);
				$(updateList).find('form#formupdateeducation').find('input[name="jurusan_update"]').val(data.data.jurusan);
				CKEDITOR.instances['keterangan_edu_update'].setData(data.data.keterangan);
	      		$('#updatedataeducation').modal('show');
	    	//alert(id);
	    	}, 'json');
	  	});
	</script>
<!-- End Update Data -->

<!-- Delete Data -->
	<script type="text/javascript">
		$(document).on('click', '.hapusskill', function(){
	      	let id = $(this).attr('id');
	      	$.ajax({
	        	url : "{{ route('skilldelete') }}",
	        	type : 'post',
	        	data : {
	          		id : id,
	          		'_token' : "{{ csrf_token() }}"
	        	},
	        	success: function(params){
		          	alert(params.text);
		          	window.location = "{{route('about')}}"
		        },
	        	error: function(xhr){
	          		alert(xhr)
	        	}
	      	});
	    });

	    $(document).on('click', '.hapusexperience', function(){
	      	let id = $(this).attr('id');
	      	$.ajax({
	        	url : "{{ route('experiencedelete') }}",
	        	type : 'post',
	        	data : {
	          		id : id,
	          		'_token' : "{{ csrf_token() }}"
	        	},
	        	success: function(params){
		          	alert(params.text);
		          	window.location = "{{route('about')}}"
		        },
	        	error: function(xhr){
	          		alert(xhr)
	        	}
	      	});
	    });

	    $(document).on('click', '.hapusedu', function(){
	      	let id = $(this).attr('id');
	      	$.ajax({
	        	url : "{{ route('educationdelete') }}",
	        	type : 'post',
	        	data : {
	          		id : id,
	          		'_token' : "{{ csrf_token() }}"
	        	},
	        	success: function(params){
		          	alert(params.text);
		          	window.location = "{{route('about')}}"
		        },
	        	error: function(xhr){
	          		alert(xhr)
	        	}
	      	});
	    });
	</script>
<!-- End Delete Data -->
@endsection