<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tentang;
use App\Models\Administrator;
use App\Models\Achievement;
use App\Models\Portofolio;
use App\Models\Kategori_porto;
use App\Models\Testimoni;
use App\Models\Pesan;
use App\Models\Skill;
use App\Models\Experience;
use App\Models\Education;
use App\Models\Blog;

class ApiController extends Controller
{
    //
    public function tentang_get()
    {
        $tentang = Tentang::all();
        return response([
            'success' => true,
            'message' => 'List Data Tentang Website',
            'data' => $tentang
        ], 200);
    }
    public function admin_get()
    {
        $admin = Administrator::all();
        return response([
            'success' => true,
            'message' => 'List Data Administrator',
            'data' => $admin
        ], 200);
    }
    public function achievement_get()
    {
        $admin = Achievement::all();
        return response([
            'success' => true,
            'message' => 'List Data Achievement',
            'data' => $admin
        ], 200);
    }
    public function kategori_portfolio_get()
    {
        $admin = Kategori_porto::all();
        return response([
            'success' => true,
            'message' => 'List Data Kategori Portofolio',
            'data' => $admin
        ], 200);
    }
    public function portfolio_get()
    {
        $admin = Portofolio::all();
        return response([
            'success' => true,
            'message' => 'List Data Portofolio',
            'data' => $admin
        ], 200);
    }
    public function portofolio_get_bycategory(Request $request)
    {
        $admin = Portofolio::where('id_kategori', $request->id)->get();
        return response([
            'success' => true,
            'message' => 'List Data Achievement',
            'data' => $admin
        ], 200);
    }
    public function testimoni_get()
    {
        $admin = Testimoni::all();
        return response([
            'success' => true,
            'message' => 'List Data Testimoni',
            'data' => $admin
        ], 200);
    }
    public function pesan_get()
    {
        $admin = Pesan::all();
        return response([
            'success' => true,
            'message' => 'List Data Pesan',
            'data' => $admin
        ], 200);
    }
    public function skill_get()
    {
        $admin = Skill::all();
        return response([
            'success' => true,
            'message' => 'List Data Skill',
            'data' => $admin
        ], 200);
    }
    public function experience_get()
    {
        $admin = Experience::all();
        return response([
            'success' => true,
            'message' => 'List Data Experience',
            'data' => $admin
        ], 200);
    }
    public function education_get()
    {
        $admin = Education::all();
        return response([
            'success' => true,
            'message' => 'List Data Education',
            'data' => $admin
        ], 200);
    }
    public function blog_get()
    {
        $admin = Blog::all();
        return response([
            'success' => true,
            'message' => 'List Data Blog',
            'data' => $admin
        ], 200);
    }
    public function blog_get_by_id(Request $request)
    {
        $admin = Blog::find($request->id)->get();
        return response([
            'success' => true,
            'message' => 'List Data Blog',
            'data' => $admin
        ], 200);
    }
    public function pesan_post(Request $request)
    {
        $pesan = Pesan::create([
                'nama'     => $request->input('nama'),
                'email'   => $request->input('email'),
                'subject' => $request->input('subject'),
                'whatsapp' => $request->input('whatsapp'),
                'message' => $request->input('message')
        ]);
        if ($pesan) {
            return response()->json([
                'success' => true,
                'message' => 'Pesan Berhasil Disimpan!'
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Pesan Gagal Disimpan!',
            ], 401);
        }
    }
    public function blog_suka(Request $request)
    {
        $blog = Blog::find($request->id)->updte([
                'suka'     => $request->suka
        ]);
        if ($blog) {
            return response()->json([
                'success' => true,
                'message' => 'Data Berhasil Diupdate!'
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Data Gagal Diupdate!',
            ], 401);
        }
    }
    public function blog_view(Request $request)
    {
        $blog = Blog::find($request->id)->updte([
                'view'     => $request->view
        ]);
        if ($blog) {
            return response()->json([
                'success' => true,
                'message' => 'Data Berhasil Diupdate!'
            ], 200);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Data Gagal Diupdate!',
            ], 401);
        }
    }
}
