<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tentang;
use App\Models\Administrator;
use App\Models\Achievement;
use App\Models\Portofolio;
use App\Models\Kategori_porto;
use App\Models\Testimoni;
use App\Models\Pesan;
use App\Models\Skill;
use App\Models\Experience;
use App\Models\Education;
use App\Models\Blog;
use Yajra\DataTables\DataTables;
use Session;


class Getcontroller extends Controller
{
    //
    public function home()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang
        ];
        return view('admin.home')->with($data);
    }
    public function about()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang
        ];
        return view('admin.about')->with($data);
    }
    public function skilljson()
    {
        $skill = Skill::orderBy('id', 'DESC')->get();
        return Datatables::of(Skill::all())
        ->addColumn('aksi', function($skill){
            $button = "<button class='updateskill btn btn-primary' id='".$skill->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapusskill btn btn-danger' id='".$skill->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['aksi'])->make(true);
    }
    public function experiencejson()
    {
        $experience = Experience::orderBy('id', 'DESC')->get();
        return Datatables::of(Experience::all())
        ->addColumn('aksi', function($experience){
            $button = "<button class='viewexperience btn btn-primary' id='".$experience->id."'><i class='fas fa-eye'></i></button>";
            $button .= "<button class='ms-2 updateexperience btn btn-success' id='".$experience->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapusexperience btn btn-danger' id='".$experience->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['aksi'])->make(true);
    }
    public function educationjson()
    {
        $edu = Education::orderBy('id', 'DESC')->get();
        return Datatables::of(Education::all())
        ->addColumn('aksi', function($edu){
            $button = "<button class='viewedu btn btn-primary' id='".$edu->id."'><i class='fas fa-eye'></i></button>";
            $button .= "<button class='updateedu ms-2 btn btn-success' id='".$edu->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapusedu btn btn-danger' id='".$edu->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['aksi'])->make(true);
    }
    public function experienceview(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Experience::find($id);
        return response()->json(['data' => $data]);
    }
    public function educationview(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $id = $request->id;
        $data = Education::find($id);
        return response()->json(['data' => $data]);
    }
    public function achievement()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $prestasi = Achievement::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'prestasi' => $prestasi
        ];
        return view('admin.prestasi')->with($data);
    }
    public function achievementjson()
    {
        $prestasi = Achievement::orderBy('id', 'DESC')->get();
        return Datatables::of(Achievement::all())
        ->addColumn('image', function($prestasi){
            $img = "<img class='m-1' src='".asset("mystyle/image/prestasi/".$prestasi->foto)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($prestasi){
            $button = "<button class='update btn btn-primary' id='".$prestasi->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$prestasi->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function portfolio()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $kategori = Kategori_porto::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'kategori' => $kategori
        ];
        return view('admin.portofolio')->with($data);
    }
    public function portfoliojson1()
    {
        $porto = Portofolio::get();
        return Datatables::of(Portofolio::where('id_kategori', 1)->get())
        ->addColumn('image', function($porto){
            $img = "<img class='m-1' src='".asset("mystyle/image/portofolio/".$porto->thumbnail)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($porto){
            $button = "<button class='update btn btn-primary' id='".$porto->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$porto->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function portfoliojson2()
    {
        $porto = Portofolio::get();
        return Datatables::of(Portofolio::where('id_kategori', 2)->get())
        ->addColumn('image', function($porto){
            $img = "<img class='m-1' src='".asset("mystyle/image/portofolio/".$porto->thumbnail)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($porto){
            $button = "<button class='update btn btn-primary' id='".$porto->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$porto->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function portfoliojson3()
    {
        $porto = Portofolio::get();
        return Datatables::of(Portofolio::where('id_kategori', 3)->get())
        ->addColumn('image', function($porto){
            $img = "<img class='m-1' src='".asset("mystyle/image/portofolio/".$porto->thumbnail)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($porto){
            $button = "<button class='update btn btn-primary' id='".$porto->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$porto->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function portfoliojson4()
    {
        $porto = Portofolio::where('id_kategori', 4)->get();
        return Datatables::of(Portofolio::where('id_kategori', 4)->get())
        ->addColumn('image', function($porto){
            $img = "<img class='m-1' src='".asset("mystyle/image/portofolio/".$porto->thumbnail)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($porto){
            $button = "<button class='update btn btn-primary' id='".$porto->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$porto->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function portfoliojson5()
    {
        $porto = Portofolio::where('id_kategori', 5)->get();
        return Datatables::of(Portofolio::where('id_kategori', 5)->get())
        ->addColumn('image', function($porto){
            $img = "<img class='m-1' src='".asset("mystyle/image/portofolio/".$porto->thumbnail)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($porto){
            $button = "<button class='update btn btn-primary' id='".$porto->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$porto->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function portfoliojson6()
    {
        $porto = Portofolio::where('id_kategori', 6)->get();
        return Datatables::of(Portofolio::where('id_kategori', 6)->get())
        ->addColumn('image', function($porto){
            $img = "<img class='m-1' src='".asset("mystyle/image/portofolio/".$porto->thumbnail)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($porto){
            $button = "<button class='update btn btn-primary' id='".$porto->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$porto->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function testimoni()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $testimoni = Testimoni::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'testimoni' => $testimoni
        ];
        return view('admin.testimoni')->with($data);
    }
    public function testimonijson()
    {
        $testi = Testimoni::orderBy('id', 'DESC')->get();
        return Datatables::of(Testimoni::all())
        ->addColumn('image', function($testi){
            $img = "<img class='m-1' src='".asset("mystyle/image/testimoni/".$testi->foto)."' width='75%'>";
            return $img;
        })
        ->addColumn('aksi', function($testi){
            $button = "<button class='update btn btn-primary' id='".$testi->id."'><i class='fas fa-edit'></i></button>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$testi->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function pesan()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $pesan = Pesan::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'pesan' => $pesan
        ];
        return view('admin.pesan')->with($data);
    }
    public function pesanjson()
    {
        $pesan = Pesan::orderBy('id', 'DESC')->get();
        return Datatables::of(Pesan::all())
        ->addColumn('aksi', function($pesan){
            $button = "<button class='ms-2 hapus btn btn-danger' id='".$pesan->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['aksi'])->make(true);
    }
    public function blog()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $blog = Blog::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'blog' => $blog
        ];
        return view('admin.blog')->with($data);
    }
    public function blogadd()
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $blog = Blog::all();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'blog' => $blog
        ];
        return view('admin.addblog')->with($data);
    }
    public function blogjson()
    {
        $blog = Blog::get();
        return Datatables::of(Blog::all())
        ->addColumn('image', function($blog){
            $img = "<img class='m-1' src='".asset("mystyle/image/blog/".$blog->featured_image)."' width='50%'>";
            return $img;
        })
        ->addColumn('aksi', function($blog){
            $button = "<a href='/admin/blog/view/".$blog->id."' class='update btn btn-primary'><i class='fas fa-eye'></i></a>";
            $button .= "<a href='/admin/blog/edit/".$blog->id."' class='update ms-2 btn btn-success'><i class='fas fa-edit'></i></a>";
            $button .= "<button class='ms-2 hapus btn btn-danger' id='".$blog->id."'><i class='fas fa-trash'></i></button>";
            return $button;
        })
        ->rawColumns(['image', 'aksi'])->make(true);
    }
    public function blogview(Request $request)
    {
        if(!Session::has('loginid')){
            return redirect('/admin')->with(['warning' => 'Anda belum login']);
        }
        $userview = Administrator::where('id', Session('loginid'))->get();
        $tentang = Tentang::all();
        $blog = Blog::find($request->id)->get();

        $data = [
            'sessionget' => Session::has('loginid'),
            'userdata' => $userview,
            'tentang' => $tentang,
            'blog' => $blog
        ];
        return view('admin.viewblog')->with($data);
    }
}
